/*
 * Decompiled with CFR 0.152.
 */
import java.util.List;

public class TMIView {
    private _tmi_MgCanvas canvas;
    private TMIConfig config;
    private TMIController controller;
    private boolean widgetsCreated = false;
    private _tmi_MgButton prevButton;
    private _tmi_MgButton nextButton;
    private _tmi_MgButton trashButton;
    private _tmi_MgButton[] stateButtons;
    private _tmi_MgButton[] deleteButtons;
    public _tmi_MgItemPanel itemPanel;
    public _tmi_MgButton rain;
    public _tmi_MgButton creative;
    public _tmi_MgButton delete;
    public _tmi_MgButton noon;
    public _tmi_MgButton dawn;
    public _tmi_MgButton dusk;
    public _tmi_MgButton midnight;

    public TMIView(_tmi_MgCanvas _tmi_MgCanvas2, TMIConfig tMIConfig, TMIController tMIController) {
        this.canvas = _tmi_MgCanvas2;
        this.config = tMIConfig;
        this.controller = tMIController;
        this.stateButtons = new _tmi_MgButton[this.config.getNumSaves()];
        this.deleteButtons = new _tmi_MgButton[this.config.getNumSaves()];
        this.createWidgets();
    }

    public void createWidgets() {
        this.prevButton = new _tmi_MgButton("", this.controller, "prev");
        this.prevButton.icon = new _tmi_MgImage(48, 12, 12, 12);
        this.prevButton.setOwnWidth(this.canvas);
        this.prevButton.height = 12;
        this.canvas.widgets.add(this.prevButton);
        this.nextButton = new _tmi_MgButton("", this.controller, "next");
        this.nextButton.icon = new _tmi_MgImage(36, 12, 12, 12);
        this.nextButton.setOwnWidth(this.canvas);
        this.nextButton.height = 12;
        this.canvas.widgets.add(this.nextButton);
        this.itemPanel = new _tmi_MgItemPanel(0, 0, 0, 0, 0, this.config.getItems(), this.controller);
        this.canvas.widgets.add(this.itemPanel);
        this.rain = new _tmi_MgButton("", this.controller, "rain");
        this.rain.showState = true;
        this.rain.icon = new _tmi_MgImage(0, 12, 12, 12);
        this.rain.setOwnWidth(this.canvas);
        this.rain.height = 14;
        this.canvas.widgets.add(this.rain);
        this.creative = new _tmi_MgButton("", this.controller, "creative");
        this.creative.showState = true;
        this.creative.icon = new _tmi_MgImage(12, 12, 12, 12);
        this.creative.setOwnWidth(this.canvas);
        this.creative.height = 14;
        this.canvas.widgets.add(this.creative);
        this.delete = new _tmi_MgButton("", this.controller, "deleteMode");
        this.delete.icon = new _tmi_MgImage(24, 12, 12, 12);
        this.delete.showState = true;
        this.delete.setOwnWidth(this.canvas);
        this.delete.height = 14;
        this.canvas.widgets.add(this.delete);
        this.noon = new _tmi_MgButton("", this.controller, "noon");
        this.noon.icon = new _tmi_MgImage(0, 24, 12, 12);
        this.noon.setOwnWidth(this.canvas);
        this.noon.height = 14;
        this.canvas.widgets.add(this.noon);
        this.dawn = new _tmi_MgButton("", this.controller, "dawn");
        this.dawn.icon = new _tmi_MgImage(12, 24, 12, 12);
        this.dawn.setOwnWidth(this.canvas);
        this.dawn.height = 14;
        this.canvas.widgets.add(this.dawn);
        this.dusk = new _tmi_MgButton("", this.controller, "dusk");
        this.dusk.icon = new _tmi_MgImage(24, 24, 12, 12);
        this.dusk.setOwnWidth(this.canvas);
        this.dusk.height = 14;
        this.canvas.widgets.add(this.dusk);
        this.midnight = new _tmi_MgButton("", this.controller, "midnight");
        this.midnight.icon = new _tmi_MgImage(36, 24, 12, 12);
        this.midnight.setOwnWidth(this.canvas);
        this.midnight.height = 14;
        this.canvas.widgets.add(this.midnight);
        this.delete.x = 2;
        this.delete.y = 2;
        this.canvas.arrangeHorizontally(1, 1001, this.delete, this.creative, this.rain, this.dawn, this.noon, this.dusk, this.midnight);
        this.stateButtons = new _tmi_MgButton[this.config.getNumSaves()];
        for (int i2 = 0; i2 < this.config.getNumSaves(); ++i2) {
            this.stateButtons[i2] = new _tmi_MgButton("Save " + (i2 + 1), this.controller, new TMIStateButtonData(i2, 0));
            this.canvas.widgets.add(this.stateButtons[i2]);
            this.deleteButtons[i2] = new _tmi_MgButton("x", this.controller, new TMIStateButtonData(i2, 1));
            this.canvas.widgets.add(this.deleteButtons[i2]);
        }
        this.widgetsCreated = true;
    }

    public void layout(int n2, int n3, int n4, int n5) {
        int n6;
        if (!this.widgetsCreated) {
            this.createWidgets();
        }
        this.itemPanel.x = (n2 + n4) / 2 + 5;
        this.itemPanel.y = 20;
        this.itemPanel.width = n2 - this.itemPanel.x - 2;
        this.itemPanel.height = n3 - this.itemPanel.y;
        this.itemPanel.resize();
        this.rain.state = TMIUtils.isRaining();
        this.creative.state = TMIUtils.isCreativeMode();
        this.delete.state = this.controller.deleteMode;
        this.prevButton.y = 2;
        this.nextButton.y = 2;
        this.nextButton.x = n2 - this.nextButton.width - 2;
        this.prevButton.x = this.nextButton.x - this.prevButton.width - 2;
        String string = "" + (_tmi_MgItemPanel.page + 1) + "/" + this.itemPanel.numPages;
        int n7 = this.prevButton.x - 4 - this.canvas.getTextWidth(string);
        this.canvas.drawText(2, n3 - 13, "TooManyItems 1.0.0 2011-11-29   ModLoader " + (TMIConfig.isModloaderEnabled ? "ON" : "OFF"), 0x454545);
        this.canvas.drawText(n7, 4, string, -1);
        this.rain.show = TMIConfig.canChangeWeather();
        this.creative.show = TMIConfig.canChangeCreativeMode();
        this.delete.show = TMIConfig.canDelete();
        this.dusk.show = this.midnight.show = TMIConfig.canChangeTime();
        this.noon.show = this.midnight.show;
        this.dawn.show = this.midnight.show;
        boolean bl2 = TMIConfig.canRestoreSaves();
        int n8 = 0;
        for (n6 = 0; n6 < this.config.getNumSaves(); ++n6) {
            this.deleteButtons[n6].x = -1000;
            this.stateButtons[n6].y = 30 + n6 * 22;
            this.stateButtons[n6].height = 20;
            String string2 = this.config.getSettings().get("save-name" + (n6 + 1));
            if (string2 == null) {
                string2 = "" + (n6 + 1);
            }
            this.stateButtons[n6].label = this.config.isStateSaved(n6) ? "Load " + string2 : "Save " + string2;
            int n9 = this.canvas.getTextWidth(this.stateButtons[n6].label) + 26;
            if (n9 + 2 + 20 > this.canvas.windowX) {
                n9 = this.canvas.windowX - 20 - 2;
            }
            if (n9 <= n8) continue;
            n8 = n9;
        }
        for (n6 = 0; n6 < this.config.getNumSaves(); ++n6) {
            this.stateButtons[n6].width = n8;
            this.stateButtons[n6].show = bl2;
            this.deleteButtons[n6].show = bl2;
            if (!this.config.isStateSaved(n6)) continue;
            this.deleteButtons[n6].x = this.stateButtons[n6].width + 2;
            this.deleteButtons[n6].y = this.stateButtons[n6].y;
            this.deleteButtons[n6].width = 20;
            this.deleteButtons[n6].height = 20;
        }
    }

    public boolean showToolTip(int n2, int n3) {
        if (this.rain != null && this.rain.contains(n2, n3)) {
            this.canvas.drawTip(n2, n3, "Rain is " + (this.rain.state ? "ON" : "OFF"));
        } else if (this.creative != null && this.creative.contains(n2, n3)) {
            this.canvas.drawTip(n2, n3, "Creative mode is " + (this.creative.state ? "ON" : "OFF"));
        } else if (this.noon != null && this.noon.contains(n2, n3)) {
            this.canvas.drawTip(n2, n3, "Set time to noon");
        } else if (this.dawn != null && this.dawn.contains(n2, n3)) {
            this.canvas.drawTip(n2, n3, "Set time to sunrise");
        } else if (this.dusk != null && this.dusk.contains(n2, n3)) {
            this.canvas.drawTip(n2, n3, "Set time to sunset");
        } else if (this.midnight != null && this.midnight.contains(n2, n3)) {
            this.canvas.drawTip(n2, n3, "Set time to midnight");
        } else if (this.delete != null && this.delete.contains(n2, n3)) {
            dk dk2 = TMIUtils.getHeldItem();
            if (dk2 == null) {
                if (TMIUtils.shiftKey()) {
                    this.canvas.drawTip(n2, n3, "DELETE ALL ITEMS from current inventory screen");
                } else {
                    this.canvas.drawTip(n2, n3, "Delete mode is " + (this.delete.state ? "ON" : "OFF"));
                }
            } else if (TMIUtils.shiftKey()) {
                this.canvas.drawTip(n2, n3, "DELETE ALL " + TMIUtils.itemDisplayName(dk2));
            } else {
                this.canvas.drawTip(n2, n3, "DELETE " + TMIUtils.itemDisplayName(dk2));
            }
        } else if (this.itemPanel.contains(n2, n3)) {
            dk dk3 = TMIUtils.getHeldItem();
            if (dk3 == null) {
                dk dk4 = this.itemPanel.getHoverItem();
                if (dk4 != null) {
                    List<String> list = TMIUtils.itemDisplayNameMultiline(dk4, true);
                    this.canvas.drawMultilineTip(n2, n3, list);
                }
            } else {
                this.canvas.drawTip(n2, n3, "DELETE " + TMIUtils.itemDisplayName(dk3));
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean isInitialized() {
        return this.widgetsCreated;
    }
}

