/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public final class ModLoader {
    private static final List<dt> animList = new LinkedList<dt>();
    private static final Map<Integer, BaseMod> blockModels = new HashMap<Integer, BaseMod>();
    private static final Map<Integer, Boolean> blockSpecialInv = new HashMap<Integer, Boolean>();
    private static final File cfgdir = new File(Minecraft.b(), "/config/");
    private static final File cfgfile = new File(cfgdir, "ModLoader.cfg");
    public static Level cfgLoggingLevel = Level.FINER;
    private static Map<String, Class<? extends ia>> classMap = null;
    private static long clock = 0L;
    public static final boolean DEBUG = false;
    private static Field field_animList = null;
    private static Field field_armorList = null;
    private static Field field_modifiers = null;
    private static Field field_TileEntityRenderers = null;
    private static boolean hasInit = false;
    private static int highestEntityId = 3000;
    private static final Map<BaseMod, Boolean> inGameHooks = new HashMap<BaseMod, Boolean>();
    private static final Map<BaseMod, Boolean> inGUIHooks = new HashMap<BaseMod, Boolean>();
    private static Minecraft instance = null;
    private static int itemSpriteIndex = 0;
    private static int itemSpritesLeft = 0;
    private static final Map<BaseMod, Map<aby, boolean[]>> keyList = new HashMap<BaseMod, Map<aby, boolean[]>>();
    private static final File logfile = new File(Minecraft.b(), "ModLoader.txt");
    private static final Logger logger = Logger.getLogger("ModLoader");
    private static FileHandler logHandler = null;
    private static Method method_RegisterEntityID = null;
    private static Method method_RegisterTileEntity = null;
    private static final File modDir = new File(Minecraft.b(), "/mods/");
    private static final LinkedList<BaseMod> modList = new LinkedList();
    private static int nextBlockModelID = 1000;
    private static final Map<Integer, Map<String, Integer>> overrides = new HashMap<Integer, Map<String, Integer>>();
    public static final Properties props = new Properties();
    private static sr[] standardBiomes;
    private static int terrainSpriteIndex;
    private static int terrainSpritesLeft;
    private static String texPack;
    private static boolean texturesAdded;
    private static final boolean[] usedItemSprites;
    private static final boolean[] usedTerrainSprites;
    public static final String VERSION = "ModLoader 1.0.0";

    static {
        terrainSpriteIndex = 0;
        terrainSpritesLeft = 0;
        texPack = null;
        texturesAdded = false;
        usedItemSprites = new boolean[256];
        usedTerrainSprites = new boolean[256];
    }

    public static void AddAchievementDesc(ws achievement, String name, String description) {
        try {
            if (achievement.i().contains(".")) {
                String[] split = achievement.i().split("\\.");
                if (split.length == 2) {
                    String key = split[1];
                    ModLoader.AddLocalization("achievement." + key, name);
                    ModLoader.AddLocalization("achievement." + key + ".desc", description);
                    ModLoader.setPrivateValue(px.class, achievement, 1, hj.a("achievement." + key));
                    ModLoader.setPrivateValue(ws.class, achievement, 3, hj.a("achievement." + key + ".desc"));
                } else {
                    ModLoader.setPrivateValue(px.class, achievement, 1, name);
                    ModLoader.setPrivateValue(ws.class, achievement, 3, description);
                }
            } else {
                ModLoader.setPrivateValue(px.class, achievement, 1, name);
                ModLoader.setPrivateValue(ws.class, achievement, 3, description);
            }
        }
        catch (IllegalArgumentException e2) {
            logger.throwing("ModLoader", "AddAchievementDesc", e2);
            ModLoader.ThrowException(e2);
        }
        catch (SecurityException e3) {
            logger.throwing("ModLoader", "AddAchievementDesc", e3);
            ModLoader.ThrowException(e3);
        }
        catch (NoSuchFieldException e4) {
            logger.throwing("ModLoader", "AddAchievementDesc", e4);
            ModLoader.ThrowException(e4);
        }
    }

    public static int AddAllFuel(int id2, int metadata) {
        logger.finest("Finding fuel for " + id2);
        int result = 0;
        Iterator iter = modList.iterator();
        while (iter.hasNext() && result == 0) {
            result = ((BaseMod)iter.next()).AddFuel(id2, metadata);
        }
        if (result != 0) {
            logger.finest("Returned " + result);
        }
        return result;
    }

    public static void AddAllRenderers(Map<Class<? extends ia>, rg> renderers) {
        if (!hasInit) {
            ModLoader.init();
            logger.fine("Initialized");
        }
        for (BaseMod mod : modList) {
            mod.AddRenderer(renderers);
        }
    }

    public static void addAnimation(dt anim) {
        logger.finest("Adding animation " + anim.toString());
        for (dt oldAnim : animList) {
            if (oldAnim.b != anim.b || oldAnim.f != anim.f) continue;
            animList.remove(anim);
            break;
        }
        animList.add(anim);
    }

    public static int AddArmor(String armor) {
        try {
            String[] existingArmor = (String[])field_armorList.get(null);
            List<String> existingArmorList = Arrays.asList(existingArmor);
            ArrayList<String> combinedList = new ArrayList<String>();
            combinedList.addAll(existingArmorList);
            if (!combinedList.contains(armor)) {
                combinedList.add(armor);
            }
            int index = combinedList.indexOf(armor);
            field_armorList.set(null, combinedList.toArray(new String[0]));
            return index;
        }
        catch (IllegalArgumentException e2) {
            logger.throwing("ModLoader", "AddArmor", e2);
            ModLoader.ThrowException("An impossible error has occured!", e2);
        }
        catch (IllegalAccessException e3) {
            logger.throwing("ModLoader", "AddArmor", e3);
            ModLoader.ThrowException("An impossible error has occured!", e3);
        }
        return -1;
    }

    public static void AddLocalization(String key, String value) {
        Properties props = null;
        try {
            props = (Properties)ModLoader.getPrivateValue(qp.class, qp.a(), 1);
        }
        catch (SecurityException e2) {
            logger.throwing("ModLoader", "AddLocalization", e2);
            ModLoader.ThrowException(e2);
        }
        catch (NoSuchFieldException e3) {
            logger.throwing("ModLoader", "AddLocalization", e3);
            ModLoader.ThrowException(e3);
        }
        if (props != null) {
            props.put(key, value);
        }
    }

    private static void addMod(ClassLoader loader, String filename) {
        try {
            Class<?> instclass;
            String name = filename.split("\\.")[0];
            if (name.contains("$")) {
                return;
            }
            if (props.containsKey(name) && (props.getProperty(name).equalsIgnoreCase("no") || props.getProperty(name).equalsIgnoreCase("off"))) {
                return;
            }
            Package pack = ModLoader.class.getPackage();
            if (pack != null) {
                name = String.valueOf(pack.getName()) + "." + name;
            }
            if (!BaseMod.class.isAssignableFrom(instclass = loader.loadClass(name))) {
                return;
            }
            ModLoader.setupProperties(instclass);
            BaseMod mod = (BaseMod)instclass.newInstance();
            if (mod != null) {
                modList.add(mod);
                logger.fine("Mod Initialized: \"" + mod.toString() + "\" from " + filename);
                System.out.println("Mod Initialized: " + mod.toString());
            }
        }
        catch (Throwable e2) {
            logger.fine("Failed to load mod from \"" + filename + "\"");
            System.out.println("Failed to load mod from \"" + filename + "\"");
            logger.throwing("ModLoader", "addMod", e2);
            ModLoader.ThrowException(e2);
        }
    }

    public static void AddName(Object instance, String name) {
        Exception e2;
        String tag = null;
        if (instance instanceof acy) {
            acy item = (acy)instance;
            if (item.d() != null) {
                tag = String.valueOf(item.d()) + ".name";
            }
        } else if (instance instanceof yy) {
            yy block = (yy)instance;
            if (block.p() != null) {
                tag = String.valueOf(block.p()) + ".name";
            }
        } else if (instance instanceof dk) {
            dk stack = (dk)instance;
            String stackTag = acy.d[stack.c].a(stack);
            if (stackTag != null) {
                tag = String.valueOf(stackTag) + ".name";
            }
        } else {
            e2 = new Exception(String.valueOf(instance.getClass().getName()) + " cannot have name attached to it!");
            logger.throwing("ModLoader", "AddName", e2);
            ModLoader.ThrowException(e2);
        }
        if (tag != null) {
            ModLoader.AddLocalization(tag, name);
        } else {
            e2 = new Exception(instance + " is missing name tag!");
            logger.throwing("ModLoader", "AddName", e2);
            ModLoader.ThrowException(e2);
        }
    }

    public static int addOverride(String fileToOverride, String fileToAdd) {
        try {
            int i2 = ModLoader.getUniqueSpriteIndex(fileToOverride);
            ModLoader.addOverride(fileToOverride, fileToAdd, i2);
            return i2;
        }
        catch (Throwable e2) {
            logger.throwing("ModLoader", "addOverride", e2);
            ModLoader.ThrowException(e2);
            throw new RuntimeException(e2);
        }
    }

    public static void addOverride(String path, String overlayPath, int index) {
        int dst = -1;
        int left = 0;
        if (path.equals("/terrain.png")) {
            dst = 0;
            left = terrainSpritesLeft;
        } else if (path.equals("/gui/items.png")) {
            dst = 1;
            left = itemSpritesLeft;
        } else {
            return;
        }
        System.out.println("Overriding " + path + " with " + overlayPath + " @ " + index + ". " + left + " left.");
        logger.finer("addOverride(" + path + "," + overlayPath + "," + index + "). " + left + " left.");
        Map<String, Integer> overlays = overrides.get(dst);
        if (overlays == null) {
            overlays = new HashMap<String, Integer>();
            overrides.put(dst, overlays);
        }
        overlays.put(overlayPath, index);
    }

    public static void AddRecipe(dk output, Object ... params) {
        sl.a().a(output, params);
    }

    public static void AddShapelessRecipe(dk output, Object ... params) {
        sl.a().b(output, params);
    }

    public static void AddSmelting(int input, dk output) {
        mt.a().a(input, output);
    }

    public static void AddSpawn(Class<? extends nq> entityClass, int weightedProb, int min, int max, jf spawnList) {
        ModLoader.AddSpawn(entityClass, weightedProb, min, max, spawnList, null);
    }

    public static void AddSpawn(Class<? extends nq> entityClass, int weightedProb, int min, int max, jf spawnList, sr ... biomes) {
        if (entityClass == null) {
            throw new IllegalArgumentException("entityClass cannot be null");
        }
        if (spawnList == null) {
            throw new IllegalArgumentException("spawnList cannot be null");
        }
        if (biomes == null) {
            biomes = standardBiomes;
        }
        int i2 = 0;
        while (i2 < biomes.length) {
            List list = biomes[i2].a(spawnList);
            if (list != null) {
                boolean exists = false;
                for (yx entry : list) {
                    if (entry.a != entityClass) continue;
                    entry.d = weightedProb;
                    entry.b = min;
                    entry.c = max;
                    exists = true;
                    break;
                }
                if (!exists) {
                    list.add(new yx(entityClass, weightedProb, min, max));
                }
            }
            ++i2;
        }
    }

    public static void AddSpawn(String entityName, int weightedProb, int min, int max, jf spawnList) {
        ModLoader.AddSpawn(entityName, weightedProb, min, max, spawnList, null);
    }

    public static void AddSpawn(String entityName, int weightedProb, int min, int max, jf spawnList, sr ... biomes) {
        Class<? extends ia> entityClass = classMap.get(entityName);
        if (entityClass != null && nq.class.isAssignableFrom(entityClass)) {
            ModLoader.AddSpawn(entityClass, weightedProb, min, max, spawnList, biomes);
        }
    }

    public static boolean DispenseEntity(ry world, double x2, double y2, double z2, int xVel, int zVel, dk item) {
        boolean result = false;
        Iterator iter = modList.iterator();
        while (iter.hasNext() && !result) {
            result = ((BaseMod)iter.next()).DispenseEntity(world, x2, y2, z2, xVel, zVel, item);
        }
        return result;
    }

    public static List<BaseMod> getLoadedMods() {
        return Collections.unmodifiableList(modList);
    }

    public static Logger getLogger() {
        return logger;
    }

    public static Minecraft getMinecraftInstance() {
        if (instance == null) {
            try {
                ThreadGroup group = Thread.currentThread().getThreadGroup();
                int count = group.activeCount();
                Thread[] threads = new Thread[count];
                group.enumerate(threads);
                int i2 = 0;
                while (i2 < threads.length) {
                    System.out.println(threads[i2].getName());
                    ++i2;
                }
                i2 = 0;
                while (i2 < threads.length) {
                    if (threads[i2].getName().equals("Minecraft main thread")) {
                        instance = (Minecraft)ModLoader.getPrivateValue(Thread.class, threads[i2], "target");
                        break;
                    }
                    ++i2;
                }
            }
            catch (SecurityException e2) {
                logger.throwing("ModLoader", "getMinecraftInstance", e2);
                throw new RuntimeException(e2);
            }
            catch (NoSuchFieldException e3) {
                logger.throwing("ModLoader", "getMinecraftInstance", e3);
                throw new RuntimeException(e3);
            }
        }
        return instance;
    }

    public static <T, E> T getPrivateValue(Class<? super E> instanceclass, E instance, int fieldindex) throws IllegalArgumentException, SecurityException, NoSuchFieldException {
        try {
            Field f2 = instanceclass.getDeclaredFields()[fieldindex];
            f2.setAccessible(true);
            return (T)f2.get(instance);
        }
        catch (IllegalAccessException e2) {
            logger.throwing("ModLoader", "getPrivateValue", e2);
            ModLoader.ThrowException("An impossible error has occured!", e2);
            return null;
        }
    }

    public static <T, E> T getPrivateValue(Class<? super E> instanceclass, E instance, String field) throws IllegalArgumentException, SecurityException, NoSuchFieldException {
        try {
            Field f2 = instanceclass.getDeclaredField(field);
            f2.setAccessible(true);
            return (T)f2.get(instance);
        }
        catch (IllegalAccessException e2) {
            logger.throwing("ModLoader", "getPrivateValue", e2);
            ModLoader.ThrowException("An impossible error has occured!", e2);
            return null;
        }
    }

    public static int getUniqueBlockModelID(BaseMod mod, boolean full3DItem) {
        int id2 = nextBlockModelID++;
        blockModels.put(id2, mod);
        blockSpecialInv.put(id2, full3DItem);
        return id2;
    }

    public static int getUniqueEntityId() {
        return highestEntityId++;
    }

    private static int getUniqueItemSpriteIndex() {
        while (itemSpriteIndex < usedItemSprites.length) {
            if (!usedItemSprites[itemSpriteIndex]) {
                ModLoader.usedItemSprites[ModLoader.itemSpriteIndex] = true;
                --itemSpritesLeft;
                return itemSpriteIndex++;
            }
            ++itemSpriteIndex;
        }
        Exception e2 = new Exception("No more empty item sprite indices left!");
        logger.throwing("ModLoader", "getUniqueItemSpriteIndex", e2);
        ModLoader.ThrowException(e2);
        return 0;
    }

    public static int getUniqueSpriteIndex(String path) {
        if (path.equals("/gui/items.png")) {
            return ModLoader.getUniqueItemSpriteIndex();
        }
        if (path.equals("/terrain.png")) {
            return ModLoader.getUniqueTerrainSpriteIndex();
        }
        Exception e2 = new Exception("No registry for this texture: " + path);
        logger.throwing("ModLoader", "getUniqueItemSpriteIndex", e2);
        ModLoader.ThrowException(e2);
        return 0;
    }

    private static int getUniqueTerrainSpriteIndex() {
        while (terrainSpriteIndex < usedTerrainSprites.length) {
            if (!usedTerrainSprites[terrainSpriteIndex]) {
                ModLoader.usedTerrainSprites[ModLoader.terrainSpriteIndex] = true;
                --terrainSpritesLeft;
                return terrainSpriteIndex++;
            }
            ++terrainSpriteIndex;
        }
        Exception e2 = new Exception("No more empty terrain sprite indices left!");
        logger.throwing("ModLoader", "getUniqueItemSpriteIndex", e2);
        ModLoader.ThrowException(e2);
        return 0;
    }

    private static void init() {
        hasInit = true;
        String usedItemSpritesString = "1111111111111111111111111111111111111101111111111111111111111111111111111111111111111111111111111111110111111111111111000111111111111101111111110000000100111111000000010000111100000000000000110000000000000000000000000000000000000000000000001111111111111111";
        String usedTerrainSpritesString = "1111111111111111111111111111110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111111100000001111111111000000001111000000000111111000000000001111111000000001111111111111111111";
        int i2 = 0;
        while (i2 < 256) {
            boolean bl2 = ModLoader.usedItemSprites[i2] = usedItemSpritesString.charAt(i2) == '1';
            if (!usedItemSprites[i2]) {
                ++itemSpritesLeft;
            }
            boolean bl3 = ModLoader.usedTerrainSprites[i2] = usedTerrainSpritesString.charAt(i2) == '1';
            if (!usedTerrainSprites[i2]) {
                ++terrainSpritesLeft;
            }
            ++i2;
        }
        try {
            instance = (Minecraft)ModLoader.getPrivateValue(Minecraft.class, null, 1);
            ModLoader.instance.u = new EntityRendererProxy(instance);
            classMap = (Map)ModLoader.getPrivateValue(afw.class, null, 0);
            field_modifiers = Field.class.getDeclaredField("modifiers");
            field_modifiers.setAccessible(true);
            field_TileEntityRenderers = ah.class.getDeclaredFields()[0];
            field_TileEntityRenderers.setAccessible(true);
            field_armorList = zr.class.getDeclaredFields()[3];
            field_modifiers.setInt(field_armorList, field_armorList.getModifiers() & 0xFFFFFFEF);
            field_armorList.setAccessible(true);
            field_animList = zh.class.getDeclaredFields()[6];
            field_animList.setAccessible(true);
            Field[] fieldArray = sr.class.getDeclaredFields();
            LinkedList<sr> biomes = new LinkedList<sr>();
            int i3 = 0;
            while (i3 < fieldArray.length) {
                sr biome;
                Class<sr> fieldType = fieldArray[i3].getType();
                if ((fieldArray[i3].getModifiers() & 8) != 0 && fieldType.isAssignableFrom(sr.class) && !((biome = (sr)fieldArray[i3].get(null)) instanceof av) && !(biome instanceof gu)) {
                    biomes.add(biome);
                }
                ++i3;
            }
            standardBiomes = biomes.toArray(new sr[0]);
            try {
                method_RegisterTileEntity = bq.class.getDeclaredMethod("a", Class.class, String.class);
            }
            catch (NoSuchMethodException e2) {
                method_RegisterTileEntity = bq.class.getDeclaredMethod("addMapping", Class.class, String.class);
            }
            method_RegisterTileEntity.setAccessible(true);
            try {
                method_RegisterEntityID = afw.class.getDeclaredMethod("a", Class.class, String.class, Integer.TYPE);
            }
            catch (NoSuchMethodException e3) {
                method_RegisterEntityID = afw.class.getDeclaredMethod("addMapping", Class.class, String.class, Integer.TYPE);
            }
            method_RegisterEntityID.setAccessible(true);
        }
        catch (SecurityException e4) {
            logger.throwing("ModLoader", "init", e4);
            ModLoader.ThrowException(e4);
            throw new RuntimeException(e4);
        }
        catch (NoSuchFieldException e5) {
            logger.throwing("ModLoader", "init", e5);
            ModLoader.ThrowException(e5);
            throw new RuntimeException(e5);
        }
        catch (NoSuchMethodException e6) {
            logger.throwing("ModLoader", "init", e6);
            ModLoader.ThrowException(e6);
            throw new RuntimeException(e6);
        }
        catch (IllegalArgumentException e7) {
            logger.throwing("ModLoader", "init", e7);
            ModLoader.ThrowException(e7);
            throw new RuntimeException(e7);
        }
        catch (IllegalAccessException e8) {
            logger.throwing("ModLoader", "init", e8);
            ModLoader.ThrowException(e8);
            throw new RuntimeException(e8);
        }
        try {
            ModLoader.loadConfig();
            if (props.containsKey("loggingLevel")) {
                cfgLoggingLevel = Level.parse(props.getProperty("loggingLevel"));
            }
            if (props.containsKey("grassFix")) {
                acr.cfgGrassFix = Boolean.parseBoolean(props.getProperty("grassFix"));
            }
            logger.setLevel(cfgLoggingLevel);
            if ((logfile.exists() || logfile.createNewFile()) && logfile.canWrite() && logHandler == null) {
                logHandler = new FileHandler(logfile.getPath());
                logHandler.setFormatter(new SimpleFormatter());
                logger.addHandler(logHandler);
            }
            logger.fine("ModLoader 1.0.0 Initializing...");
            System.out.println("ModLoader 1.0.0 Initializing...");
            File source = new File(ModLoader.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            modDir.mkdirs();
            ModLoader.readFromClassPath(source);
            ModLoader.readFromModFolder(modDir);
            ModLoader.sortModList();
            for (BaseMod mod : modList) {
                mod.load();
                logger.fine("Mod Loaded: \"" + mod.toString() + "\"");
                System.out.println("Mod Loaded: " + mod.toString());
                if (props.containsKey(mod.getClass().getSimpleName())) continue;
                props.setProperty(mod.getClass().getSimpleName(), "on");
            }
            for (BaseMod mod : modList) {
                mod.ModsLoaded();
            }
            System.out.println("Done.");
            props.setProperty("loggingLevel", cfgLoggingLevel.getName());
            props.setProperty("grassFix", Boolean.toString(acr.cfgGrassFix));
            ModLoader.instance.A.A = ModLoader.RegisterAllKeys(ModLoader.instance.A.A);
            ModLoader.instance.A.a();
            ModLoader.initStats();
            ModLoader.saveConfig();
        }
        catch (Throwable e9) {
            logger.throwing("ModLoader", "init", e9);
            ModLoader.ThrowException("ModLoader has failed to initialize.", e9);
            if (logHandler != null) {
                logHandler.close();
            }
            throw new RuntimeException(e9);
        }
    }

    private static void sortModList() throws Exception {
        HashMap<String, BaseMod> loadedMods = new HashMap<String, BaseMod>();
        for (BaseMod mod : ModLoader.getLoadedMods()) {
            loadedMods.put(mod.getClass().getSimpleName(), mod);
        }
        LinkedList<BaseMod> newList = new LinkedList<BaseMod>();
        int pass = 0;
        while (newList.size() != modList.size()) {
            if (pass > 10) break;
            block2: for (BaseMod mod : modList) {
                if (newList.contains(mod)) continue;
                String priority = mod.getPriorities();
                if (priority == null || priority.length() == 0 || priority.indexOf(58) == -1) {
                    newList.add(mod);
                    continue;
                }
                if (pass <= 0) continue;
                int newIndex = -1;
                int max = Integer.MIN_VALUE;
                int min = Integer.MAX_VALUE;
                String[] rules = priority.indexOf(59) > 0 ? priority.split(";") : new String[]{priority};
                int i2 = 0;
                while (i2 < rules.length) {
                    String rule = rules[i2];
                    if (rule.indexOf(58) != -1) {
                        String[] keyValuePair = rule.split(":");
                        String key = keyValuePair[0];
                        String value = keyValuePair[1];
                        if (key.contentEquals("before") || key.contentEquals("after")) {
                            if (value.contentEquals("*")) {
                                if (key.contentEquals("before")) {
                                    newIndex = 0;
                                    break;
                                }
                                if (!key.contentEquals("after")) break;
                                newIndex = newList.size();
                                break;
                            }
                            if (!loadedMods.containsKey(value)) {
                                throw new Exception(String.format("%s is missing dependency: %s", mod, value));
                            }
                            BaseMod mod2 = (BaseMod)loadedMods.get(value);
                            if (!newList.contains(mod2)) continue block2;
                            int index = newList.indexOf(mod2);
                            if (key.contentEquals("before")) {
                                newIndex = index;
                                if (newIndex < min) {
                                    min = newIndex;
                                } else {
                                    newIndex = min;
                                }
                            } else if (key.contentEquals("after")) {
                                newIndex = index + 1;
                                if (newIndex > max) {
                                    max = newIndex;
                                } else {
                                    newIndex = max;
                                }
                            }
                        }
                    }
                    ++i2;
                }
                if (newIndex == -1) continue;
                newList.add(newIndex, mod);
            }
            ++pass;
        }
        modList.clear();
        modList.addAll(newList);
    }

    private static void initStats() {
        String str;
        int id2 = 0;
        while (id2 < yy.k.length) {
            if (!ny.a.containsKey(0x1000000 + id2) && yy.k[id2] != null && yy.k[id2].q()) {
                str = qp.a().a("stat.mineBlock", yy.k[id2].o());
                ny.C[id2] = new yl(0x1000000 + id2, str, id2).a();
                ny.e.add(ny.C[id2]);
            }
            ++id2;
        }
        id2 = 0;
        while (id2 < acy.d.length) {
            if (!ny.a.containsKey(0x1020000 + id2) && acy.d[id2] != null) {
                str = qp.a().a("stat.useItem", acy.d[id2].k());
                ny.E[id2] = new yl(0x1020000 + id2, str, id2).a();
                if (id2 >= yy.k.length) {
                    ny.d.add(ny.E[id2]);
                }
            }
            if (!ny.a.containsKey(0x1030000 + id2) && acy.d[id2] != null && acy.d[id2].h()) {
                str = qp.a().a("stat.breakItem", acy.d[id2].k());
                ny.F[id2] = new yl(0x1030000 + id2, str, id2).a();
            }
            ++id2;
        }
        HashSet<Integer> idHashSet = new HashSet<Integer>();
        for (Object result : sl.a().b()) {
            idHashSet.add(((ue)result).a().c);
        }
        for (Object result : mt.a().b().values()) {
            idHashSet.add(((dk)result).c);
        }
        Iterator<Object> iterator = idHashSet.iterator();
        while (iterator.hasNext()) {
            int id3 = (Integer)iterator.next();
            if (ny.a.containsKey(0x1010000 + id3) || acy.d[id3] == null) continue;
            String str2 = qp.a().a("stat.craftItem", acy.d[id3].k());
            ny.D[id3] = new yl(0x1010000 + id3, str2, id3).a();
        }
    }

    public static boolean isGUIOpen(Class<? extends xe> gui) {
        Minecraft game = ModLoader.getMinecraftInstance();
        if (gui == null) {
            return game.s == null;
        }
        if (game.s == null && gui != null) {
            return false;
        }
        return gui.isInstance(game.s);
    }

    public static boolean isModLoaded(String modname) {
        Class<?> chk = null;
        try {
            chk = Class.forName(modname);
        }
        catch (ClassNotFoundException e2) {
            return false;
        }
        if (chk != null) {
            for (BaseMod mod : modList) {
                if (!chk.isInstance(mod)) continue;
                return true;
            }
        }
        return false;
    }

    public static void loadConfig() throws IOException {
        cfgdir.mkdir();
        if (!cfgfile.exists() && !cfgfile.createNewFile()) {
            return;
        }
        if (cfgfile.canRead()) {
            FileInputStream in2 = new FileInputStream(cfgfile);
            props.load(in2);
            ((InputStream)in2).close();
        }
    }

    public static BufferedImage loadImage(zh texCache, String path) throws Exception {
        adk pack = (adk)ModLoader.getPrivateValue(zh.class, texCache, 11);
        InputStream input = pack.a.a(path);
        if (input == null) {
            throw new Exception("Image not found: " + path);
        }
        BufferedImage image = ImageIO.read(input);
        if (image == null) {
            throw new Exception("Image corrupted: " + path);
        }
        return image;
    }

    public static void OnItemPickup(vi player, dk item) {
        for (BaseMod mod : modList) {
            mod.OnItemPickup(player, item);
        }
    }

    public static void OnTick(float tick, Minecraft game) {
        Map.Entry<BaseMod, Boolean> modSet;
        Iterator<Map.Entry<BaseMod, Boolean>> iter;
        pf.b();
        pf.b();
        pf.a("modtick");
        if (!hasInit) {
            ModLoader.init();
            logger.fine("Initialized");
        }
        if (texPack == null || game.A.m != texPack) {
            texturesAdded = false;
            texPack = game.A.m;
        }
        if (!texturesAdded && game.p != null) {
            ModLoader.RegisterAllTextureOverrides(game.p);
            texturesAdded = true;
        }
        long newclock = 0L;
        if (game.f != null) {
            newclock = game.f.u();
            iter = inGameHooks.entrySet().iterator();
            while (iter.hasNext()) {
                modSet = iter.next();
                if (clock == newclock && modSet.getValue().booleanValue() || modSet.getKey().OnTickInGame(tick, game)) continue;
                iter.remove();
            }
        }
        if (game.r != null) {
            iter = inGUIHooks.entrySet().iterator();
            while (iter.hasNext()) {
                modSet = iter.next();
                if (clock == newclock && modSet.getValue() & game.f != null || modSet.getKey().OnTickInGUI(tick, game, game.s)) continue;
                iter.remove();
            }
        }
        if (clock != newclock) {
            for (Map.Entry<BaseMod, Map<aby, boolean[]>> modSet2 : keyList.entrySet()) {
                for (Map.Entry<aby, boolean[]> keySet : modSet2.getValue().entrySet()) {
                    int key = keySet.getKey().d;
                    boolean state = key < 0 ? Mouse.isButtonDown((int)(key += 100)) : Keyboard.isKeyDown((int)key);
                    boolean[] keyInfo = keySet.getValue();
                    boolean oldState = keyInfo[1];
                    keyInfo[1] = state;
                    if (!state || oldState && !keyInfo[0]) continue;
                    modSet2.getKey().KeyboardEvent(keySet.getKey());
                }
            }
        }
        clock = newclock;
        pf.b();
        pf.a("render");
        pf.a("gameRenderer");
    }

    public static void OpenGUI(vi player, xe gui) {
        if (!hasInit) {
            ModLoader.init();
            logger.fine("Initialized");
        }
        Minecraft game = ModLoader.getMinecraftInstance();
        if (game.i != player) {
            return;
        }
        if (gui != null) {
            game.a(gui);
        }
    }

    public static void PopulateChunk(ej generator, int chunkX, int chunkZ, ry world) {
        if (!hasInit) {
            ModLoader.init();
            logger.fine("Initialized");
        }
        Random rnd = new Random(world.t());
        long xSeed = rnd.nextLong() / 2L * 2L + 1L;
        long zSeed = rnd.nextLong() / 2L * 2L + 1L;
        rnd.setSeed((long)chunkX * xSeed + (long)chunkZ * zSeed ^ world.t());
        for (BaseMod mod : modList) {
            if (generator.c().equals("RandomLevelSource")) {
                mod.GenerateSurface(world, rnd, chunkX << 4, chunkZ << 4);
                continue;
            }
            if (!generator.c().equals("HellRandomLevelSource")) continue;
            mod.GenerateNether(world, rnd, chunkX << 4, chunkZ << 4);
        }
    }

    private static void readFromClassPath(File source) throws FileNotFoundException, IOException {
        logger.finer("Adding mods from " + source.getCanonicalPath());
        ClassLoader loader = ModLoader.class.getClassLoader();
        if (source.isFile() && (source.getName().endsWith(".jar") || source.getName().endsWith(".zip"))) {
            logger.finer("Zip found.");
            FileInputStream input = new FileInputStream(source);
            ZipInputStream zip = new ZipInputStream(input);
            ZipEntry entry = null;
            while ((entry = zip.getNextEntry()) != null) {
                String name = entry.getName();
                if (entry.isDirectory() || !name.startsWith("mod_") || !name.endsWith(".class")) continue;
                ModLoader.addMod(loader, name);
            }
            ((InputStream)input).close();
        } else if (source.isDirectory()) {
            Package pkg = ModLoader.class.getPackage();
            if (pkg != null) {
                String pkgdir = pkg.getName().replace('.', File.separatorChar);
                source = new File(source, pkgdir);
            }
            logger.finer("Directory found.");
            File[] files = source.listFiles();
            if (files != null) {
                int i2 = 0;
                while (i2 < files.length) {
                    String name = files[i2].getName();
                    if (files[i2].isFile() && name.startsWith("mod_") && name.endsWith(".class")) {
                        ModLoader.addMod(loader, name);
                    }
                    ++i2;
                }
            }
        }
    }

    private static void readFromModFolder(File folder) throws IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        Object source;
        int file;
        ClassLoader loader = Minecraft.class.getClassLoader();
        Method addURL = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        addURL.setAccessible(true);
        if (!folder.isDirectory()) {
            throw new IllegalArgumentException("folder must be a Directory.");
        }
        Object[] sourcefiles = folder.listFiles();
        Arrays.sort(sourcefiles);
        if (loader instanceof URLClassLoader) {
            file = 0;
            while (file < sourcefiles.length) {
                source = sourcefiles[file];
                if (((File)source).isDirectory() || ((File)source).isFile() && (((File)source).getName().endsWith(".jar") || ((File)source).getName().endsWith(".zip"))) {
                    addURL.invoke((Object)loader, ((File)source).toURI().toURL());
                }
                ++file;
            }
        }
        file = 0;
        while (file < sourcefiles.length) {
            source = sourcefiles[file];
            if (((File)source).isDirectory() || ((File)source).isFile() && (((File)source).getName().endsWith(".jar") || ((File)source).getName().endsWith(".zip"))) {
                String name;
                logger.finer("Adding mods from " + ((File)source).getCanonicalPath());
                if (((File)source).isFile()) {
                    logger.finer("Zip found.");
                    FileInputStream input = new FileInputStream((File)source);
                    ZipInputStream zip = new ZipInputStream(input);
                    ZipEntry entry = null;
                    while ((entry = zip.getNextEntry()) != null) {
                        name = entry.getName();
                        if (entry.isDirectory() || !name.startsWith("mod_") || !name.endsWith(".class")) continue;
                        ModLoader.addMod(loader, name);
                    }
                    zip.close();
                    ((InputStream)input).close();
                } else if (((File)source).isDirectory()) {
                    Package pkg = ModLoader.class.getPackage();
                    if (pkg != null) {
                        String pkgdir = pkg.getName().replace('.', File.separatorChar);
                        source = new File((File)source, pkgdir);
                    }
                    logger.finer("Directory found.");
                    File[] dirfiles = ((File)source).listFiles();
                    if (dirfiles != null) {
                        int j2 = 0;
                        while (j2 < dirfiles.length) {
                            name = dirfiles[j2].getName();
                            if (dirfiles[j2].isFile() && name.startsWith("mod_") && name.endsWith(".class")) {
                                ModLoader.addMod(loader, name);
                            }
                            ++j2;
                        }
                    }
                }
            }
            ++file;
        }
    }

    public static aby[] RegisterAllKeys(aby[] keys) {
        LinkedList<aby> combinedList = new LinkedList<aby>();
        combinedList.addAll(Arrays.asList(keys));
        for (Map<aby, boolean[]> keyMap : keyList.values()) {
            combinedList.addAll(keyMap.keySet());
        }
        return combinedList.toArray(new aby[0]);
    }

    public static void RegisterAllTextureOverrides(zh cache) {
        animList.clear();
        Minecraft game = ModLoader.getMinecraftInstance();
        for (BaseMod baseMod : modList) {
            baseMod.RegisterAnimation(game);
        }
        for (dt dt2 : animList) {
            cache.a(dt2);
        }
        for (Map.Entry entry : overrides.entrySet()) {
            for (Map.Entry overlayEntry : ((Map)entry.getValue()).entrySet()) {
                String overlayPath = (String)overlayEntry.getKey();
                int index = (Integer)overlayEntry.getValue();
                int dst = (Integer)entry.getKey();
                try {
                    BufferedImage im2 = ModLoader.loadImage(cache, overlayPath);
                    ModTextureStatic anim = new ModTextureStatic(index, dst, im2);
                    cache.a(anim);
                }
                catch (Exception e2) {
                    logger.throwing("ModLoader", "RegisterAllTextureOverrides", e2);
                    ModLoader.ThrowException(e2);
                    throw new RuntimeException(e2);
                }
            }
        }
    }

    public static void RegisterBlock(yy block) {
        ModLoader.RegisterBlock(block, null);
    }

    public static void RegisterBlock(yy block, Class<? extends uw> itemclass) {
        try {
            if (block == null) {
                throw new IllegalArgumentException("block parameter cannot be null.");
            }
            int id2 = block.bM;
            uw item = null;
            item = itemclass != null ? itemclass.getConstructor(Integer.TYPE).newInstance(id2 - 256) : new uw(id2 - 256);
            if (yy.k[id2] != null && acy.d[id2] == null) {
                acy.d[id2] = item;
            }
        }
        catch (IllegalArgumentException e2) {
            logger.throwing("ModLoader", "RegisterBlock", e2);
            ModLoader.ThrowException(e2);
        }
        catch (IllegalAccessException e3) {
            logger.throwing("ModLoader", "RegisterBlock", e3);
            ModLoader.ThrowException(e3);
        }
        catch (SecurityException e4) {
            logger.throwing("ModLoader", "RegisterBlock", e4);
            ModLoader.ThrowException(e4);
        }
        catch (InstantiationException e5) {
            logger.throwing("ModLoader", "RegisterBlock", e5);
            ModLoader.ThrowException(e5);
        }
        catch (InvocationTargetException e6) {
            logger.throwing("ModLoader", "RegisterBlock", e6);
            ModLoader.ThrowException(e6);
        }
        catch (NoSuchMethodException e7) {
            logger.throwing("ModLoader", "RegisterBlock", e7);
            ModLoader.ThrowException(e7);
        }
    }

    public static void RegisterEntityID(Class<? extends ia> entityClass, String entityName, int id2) {
        try {
            method_RegisterEntityID.invoke(null, entityClass, entityName, id2);
        }
        catch (IllegalArgumentException e2) {
            logger.throwing("ModLoader", "RegisterEntityID", e2);
            ModLoader.ThrowException(e2);
        }
        catch (IllegalAccessException e3) {
            logger.throwing("ModLoader", "RegisterEntityID", e3);
            ModLoader.ThrowException(e3);
        }
        catch (InvocationTargetException e4) {
            logger.throwing("ModLoader", "RegisterEntityID", e4);
            ModLoader.ThrowException(e4);
        }
    }

    public static void RegisterKey(BaseMod mod, aby keyHandler, boolean allowRepeat) {
        Map<aby, boolean[]> keyMap = keyList.get(mod);
        if (keyMap == null) {
            keyMap = new HashMap<aby, boolean[]>();
        }
        boolean[] blArray = new boolean[2];
        blArray[0] = allowRepeat;
        keyMap.put(keyHandler, blArray);
        keyList.put(mod, keyMap);
    }

    public static void RegisterTileEntity(Class<? extends bq> tileEntityClass, String id2) {
        ModLoader.RegisterTileEntity(tileEntityClass, id2, null);
    }

    public static void RegisterTileEntity(Class<? extends bq> tileEntityClass, String id2, du renderer) {
        try {
            method_RegisterTileEntity.invoke(null, tileEntityClass, id2);
            if (renderer != null) {
                ah ref = ah.a;
                Map renderers = (Map)field_TileEntityRenderers.get(ref);
                renderers.put(tileEntityClass, renderer);
                renderer.a(ref);
            }
        }
        catch (IllegalArgumentException e2) {
            logger.throwing("ModLoader", "RegisterTileEntity", e2);
            ModLoader.ThrowException(e2);
        }
        catch (IllegalAccessException e3) {
            logger.throwing("ModLoader", "RegisterTileEntity", e3);
            ModLoader.ThrowException(e3);
        }
        catch (InvocationTargetException e4) {
            logger.throwing("ModLoader", "RegisterTileEntity", e4);
            ModLoader.ThrowException(e4);
        }
    }

    public static void RemoveSpawn(Class<? extends nq> entityClass, jf spawnList) {
        ModLoader.RemoveSpawn(entityClass, spawnList, null);
    }

    public static void RemoveSpawn(Class<? extends nq> entityClass, jf spawnList, sr ... biomes) {
        if (entityClass == null) {
            throw new IllegalArgumentException("entityClass cannot be null");
        }
        if (spawnList == null) {
            throw new IllegalArgumentException("spawnList cannot be null");
        }
        if (biomes == null) {
            biomes = standardBiomes;
        }
        int i2 = 0;
        while (i2 < biomes.length) {
            List list = biomes[i2].a(spawnList);
            if (list != null) {
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    yx entry = (yx)iter.next();
                    if (entry.a != entityClass) continue;
                    iter.remove();
                }
            }
            ++i2;
        }
    }

    public static void RemoveSpawn(String entityName, jf spawnList) {
        ModLoader.RemoveSpawn(entityName, spawnList, null);
    }

    public static void RemoveSpawn(String entityName, jf spawnList, sr ... biomes) {
        Class<? extends ia> entityClass = classMap.get(entityName);
        if (entityClass != null && nq.class.isAssignableFrom(entityClass)) {
            ModLoader.RemoveSpawn(entityClass, spawnList, biomes);
        }
    }

    public static boolean RenderBlockIsItemFull3D(int modelID) {
        if (!blockSpecialInv.containsKey(modelID)) {
            return modelID == 16;
        }
        return blockSpecialInv.get(modelID);
    }

    public static void RenderInvBlock(acr renderer, yy block, int metadata, int modelID) {
        BaseMod mod = blockModels.get(modelID);
        if (mod == null) {
            return;
        }
        mod.RenderInvBlock(renderer, block, metadata, modelID);
    }

    public static boolean RenderWorldBlock(acr renderer, kq world, int x2, int y2, int z2, yy block, int modelID) {
        BaseMod mod = blockModels.get(modelID);
        if (mod == null) {
            return false;
        }
        return mod.RenderWorldBlock(renderer, world, x2, y2, z2, block, modelID);
    }

    public static void saveConfig() throws IOException {
        cfgdir.mkdir();
        if (!cfgfile.exists() && !cfgfile.createNewFile()) {
            return;
        }
        if (cfgfile.canWrite()) {
            FileOutputStream out = new FileOutputStream(cfgfile);
            props.store(out, "ModLoader Config");
            ((OutputStream)out).close();
        }
    }

    public static void SetInGameHook(BaseMod mod, boolean enable, boolean useClock) {
        if (enable) {
            inGameHooks.put(mod, useClock);
        } else {
            inGameHooks.remove(mod);
        }
    }

    public static void SetInGUIHook(BaseMod mod, boolean enable, boolean useClock) {
        if (enable) {
            inGUIHooks.put(mod, useClock);
        } else {
            inGUIHooks.remove(mod);
        }
    }

    public static <T, E> void setPrivateValue(Class<? super T> instanceclass, T instance, int fieldindex, E value) throws IllegalArgumentException, SecurityException, NoSuchFieldException {
        try {
            Field f2 = instanceclass.getDeclaredFields()[fieldindex];
            f2.setAccessible(true);
            int modifiers = field_modifiers.getInt(f2);
            if ((modifiers & 0x10) != 0) {
                field_modifiers.setInt(f2, modifiers & 0xFFFFFFEF);
            }
            f2.set(instance, value);
        }
        catch (IllegalAccessException e2) {
            logger.throwing("ModLoader", "setPrivateValue", e2);
            ModLoader.ThrowException("An impossible error has occured!", e2);
        }
    }

    public static <T, E> void setPrivateValue(Class<? super T> instanceclass, T instance, String field, E value) throws IllegalArgumentException, SecurityException, NoSuchFieldException {
        try {
            Field f2 = instanceclass.getDeclaredField(field);
            int modifiers = field_modifiers.getInt(f2);
            if ((modifiers & 0x10) != 0) {
                field_modifiers.setInt(f2, modifiers & 0xFFFFFFEF);
            }
            f2.setAccessible(true);
            f2.set(instance, value);
        }
        catch (IllegalAccessException e2) {
            logger.throwing("ModLoader", "setPrivateValue", e2);
            ModLoader.ThrowException("An impossible error has occured!", e2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void setupProperties(Class<? extends BaseMod> mod) throws IllegalArgumentException, IllegalAccessException, IOException, SecurityException, NoSuchFieldException {
        Properties modprops = new Properties();
        File modcfgfile = new File(cfgdir, String.valueOf(mod.getName()) + ".cfg");
        if (modcfgfile.exists() && modcfgfile.canRead()) {
            modprops.load(new FileInputStream(modcfgfile));
        }
        StringBuilder helptext = new StringBuilder();
        Field[] fieldArray = mod.getFields();
        int n2 = fieldArray.length;
        int n3 = 0;
        while (n3 < n2) {
            block21: {
                Object currentvalue;
                String key;
                block22: {
                    Object value;
                    Field field;
                    block23: {
                        field = fieldArray[n3];
                        if ((field.getModifiers() & 8) == 0 || !field.isAnnotationPresent(MLProp.class)) break block21;
                        Class<Object> type = field.getType();
                        MLProp annotation = field.getAnnotation(MLProp.class);
                        key = annotation.name().length() == 0 ? field.getName() : annotation.name();
                        currentvalue = field.get(null);
                        StringBuilder range = new StringBuilder();
                        if (annotation.min() != Double.NEGATIVE_INFINITY) {
                            range.append(String.format(",>=%.1f", annotation.min()));
                        }
                        if (annotation.max() != Double.POSITIVE_INFINITY) {
                            range.append(String.format(",<=%.1f", annotation.max()));
                        }
                        StringBuilder info = new StringBuilder();
                        if (annotation.info().length() > 0) {
                            info.append(" -- ");
                            info.append(annotation.info());
                        }
                        helptext.append(String.format("%s (%s:%s%s)%s\n", key, type.getName(), currentvalue, range, info));
                        if (!modprops.containsKey(key)) break block22;
                        String strvalue = modprops.getProperty(key);
                        value = null;
                        if (type.isAssignableFrom(String.class)) {
                            value = strvalue;
                        } else if (type.isAssignableFrom(Integer.TYPE)) {
                            value = Integer.parseInt(strvalue);
                        } else if (type.isAssignableFrom(Short.TYPE)) {
                            value = Short.parseShort(strvalue);
                        } else if (type.isAssignableFrom(Byte.TYPE)) {
                            value = Byte.parseByte(strvalue);
                        } else if (type.isAssignableFrom(Boolean.TYPE)) {
                            value = Boolean.parseBoolean(strvalue);
                        } else if (type.isAssignableFrom(Float.TYPE)) {
                            value = Float.valueOf(Float.parseFloat(strvalue));
                        } else if (type.isAssignableFrom(Double.TYPE)) {
                            value = Double.parseDouble(strvalue);
                        }
                        if (value == null) break block21;
                        if (!(value instanceof Number)) break block23;
                        double num = ((Number)value).doubleValue();
                        if (annotation.min() != Double.NEGATIVE_INFINITY && num < annotation.min() || annotation.max() != Double.POSITIVE_INFINITY && num > annotation.max()) break block21;
                    }
                    logger.finer(String.valueOf(key) + " set to " + value);
                    if (!value.equals(currentvalue)) {
                        field.set(null, value);
                    }
                    break block21;
                }
                logger.finer(String.valueOf(key) + " not in config, using default: " + currentvalue);
                modprops.setProperty(key, currentvalue.toString());
            }
            ++n3;
        }
        if (!modprops.isEmpty() && (modcfgfile.exists() || modcfgfile.createNewFile()) && modcfgfile.canWrite()) {
            modprops.store(new FileOutputStream(modcfgfile), helptext.toString());
        }
    }

    public static void TakenFromCrafting(vi player, dk item, de matrix) {
        for (BaseMod mod : modList) {
            mod.TakenFromCrafting(player, item, matrix);
        }
    }

    public static void TakenFromFurnace(vi player, dk item) {
        for (BaseMod mod : modList) {
            mod.TakenFromFurnace(player, item);
        }
    }

    public static void ThrowException(String message, Throwable e2) {
        Minecraft game = ModLoader.getMinecraftInstance();
        if (game == null) {
            throw new RuntimeException(e2);
        }
        game.a(new oq(message, e2));
    }

    private static void ThrowException(Throwable e2) {
        ModLoader.ThrowException("Exception occured in ModLoader", e2);
    }

    private ModLoader() {
    }
}

